/* -*- mode: c++; c-basic-offset: 4 -*- */

#include <cstdint>
#include <string>
#include <random>
#include <string>
#include <iostream>
#include <sstream>
#include <vector>

using namespace std;

struct BookState
{
    string name;
    bool is_locked;
};

struct UserState
{
    string name;
    int state;
};

int main(int argc, char *argv[])
{
    uint32_t seed = stoul(argv[1], NULL, 10);
    uint32_t user_count = stoul(argv[2], NULL, 10);
    uint32_t count = stoul(argv[3], NULL, 10);

    mt19937 rnd(seed);

    vector<UserState> users(user_count);
    for (uint32_t i = 0; i < user_count; ++i) {
        ostringstream oss;
        oss << "User" << (i + 1);
        users[i].name = oss.str();
    }

    vector<BookState> books(user_count);
    for (uint32_t i = 0; i < user_count; ++i) {
        ostringstream oss;
        oss << "Book" << (i + 1);
        books[i].name = oss.str();
    }

    while (count > 0) {
        uint32_t i = rnd() % user_count;
        auto &u = users[i];
        uint32_t b1i = i;
        uint32_t b2i = (i + 1) % user_count;
        if (b2i < b1i) {
            swap(b1i, b2i);
        }
        if (u.state == 0) {
            cout << "B " << u.name << " " << books[b1i].name << endl;
            ++u.state;
            --count;
        } else if (u.state == 1) {
            cout << "B " << u.name << " " << books[b2i].name << endl;
            ++u.state;
            --count;
        } else if (u.state == 2) {
            cout << "R " << u.name << " " << books[b2i].name << endl;
            ++u.state;
            --count;
        } else if (u.state == 3) {
            cout << "R " << u.name << " " << books[b1i].name << endl;
            u.state = 0;
            --count;
        }
    }
    for (uint32_t i = 0; i < user_count; ++i) {
        auto &u = users[i];
        uint32_t b1i = i;
        uint32_t b2i = (i + 1) % user_count;
        if (b2i < b1i) {
            swap(b1i, b2i);
        }
        if (u.state == 1) {
            cout << "R " << u.name << " " << books[b1i].name << endl;
            u.state = 0;
        } else if (u.state == 2) {
            cout << "R " << u.name << " " << books[b2i].name << endl;
            cout << "R " << u.name << " " << books[b1i].name << endl;
            u.state = 0;
        } else if (u.state == 3) {
            cout << "R " << u.name << " " << books[b1i].name << endl;
            u.state = 0;
        }
    }
}
