/* -*- mode: c++; c-basic-offset: 4 -*- */

#include <cstdint>
#include <string>
#include <random>
#include <string>
#include <iostream>
#include <sstream>
#include <vector>
#include <algorithm>
#include <set>

using namespace std;

struct BookState
{
    string name;
    bool is_locked;
};

struct UserState
{
    string name;
    vector<uint32_t> rb;        // required books
    int state;
};

int main(int argc, char *argv[])
{
    uint32_t seed = stoul(argv[1], NULL, 10);
    uint32_t user_count = stoul(argv[2], NULL, 10);
    uint32_t count = stoul(argv[3], NULL, 10);

    mt19937 rnd(seed);

    vector<UserState> users(user_count);
    for (uint32_t i = 0; i < user_count; ++i) {
        ostringstream oss;
        oss << "User" << (i + 1);
        users[i].name = oss.str();
        users[i].rb.resize(2);
        set<uint32_t> uu;
        for (uint32_t j = 0; j < 2; ++j) {
            uint32_t b = rnd() % user_count;
            while (uu.count(b) > 0) {
                b = rnd() % user_count;
            }
            uu.insert(b);
            users[i].rb[j] = b;
        }
        //sort(users[i].rb.begin(), users[i].rb.end());
    }

    vector<BookState> books(user_count);
    for (uint32_t i = 0; i < user_count; ++i) {
        ostringstream oss;
        oss << "Book" << (i + 1);
        books[i].name = oss.str();
    }

    while (count > 0) {
        uint32_t i = rnd() % user_count;
        auto &u = users[i];
        if (u.state == 0) {
            cout << "B " << u.name << " " << books[u.rb[0]].name << endl;
            ++u.state;
            --count;
        } else if (u.state == 1) {
            cout << "B " << u.name << " " << books[u.rb[1]].name << endl;
            ++u.state;
            --count;
        } else if (u.state == 2) {
            cout << "R " << u.name << " " << books[u.rb[1]].name << endl;
            ++u.state;
            --count;
        } else if (u.state == 3) {
            cout << "R " << u.name << " " << books[u.rb[0]].name << endl;
            u.state = 0;
            --count;
        }
    }
    for (uint32_t i = 0; i < user_count; ++i) {
        auto &u = users[i];
        if (u.state == 1 || u.state == 3) {
            cout << "R " << u.name << " " << books[u.rb[0]].name << endl;
            u.state = 0;
        } else if (u.state == 2) {
            cout << "R " << u.name << " " << books[u.rb[1]].name << endl;
            cout << "R " << u.name << " " << books[u.rb[0]].name << endl;
            u.state = 0;
        }
    }
}
