/* -*- mode: c++; c-basic-offset: 4 -*- */

#include <iostream>
#include <iomanip>
#include <string>
#include <cctype>
#include <sstream>
#include <map>
#include <list>
#include <set>
#include <vector>

using namespace std;

struct BookInfo
{
    string holder;
    list<string> wq; // wait queue
};

struct UserInfo
{
    set<string> books;  // taken books
    string wb;          // the book waiting for
    size_t pos;         // current command
    bool is_waiting;
};

struct Command
{
    string cmd;
    string user;
    string book;
};

bool
check_rec(
        const map<string, UserInfo> &users,
        const map<string, BookInfo> &books,
        set<string> &visited,
        const std::string &user,
        set<string> &path)
{
    if (path.count(user) > 0) {
        return true;
    }
    if (visited.count(user) > 0) {
        return false;
    }
    visited.insert(user);
    path.insert(user);

    auto it = users.find(user);
    if (it == users.end()) abort();
    const auto &u = it->second;
    for (const auto &book : u.books) {
        auto it2 = books.find(book);
        if (it2 == books.end()) abort();
        const auto &b = it2->second;

        for (const auto &user2 : b.wq) {
            bool res = check_rec(users, books, visited, user2, path);
            if (res) return true;
        }
    }

    return false;
}

bool
check(const map<string, UserInfo> &users, const map<string, BookInfo> &books)
{
    set<string> visited;
    for (const auto &p : users) {
        if (!visited.count(p.first)) {
            set<string> path;
            bool res = check_rec(users, books, visited, p.first, path);
            if (res) return true;
        }
    }
    return false;
}

int main(int argc, char *argv[])
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    // book properties
    map<string, BookInfo> books;
    // user properties
    map<string, UserInfo> users;

    vector<Command> commands(1);
    string s;
    while (getline(cin, s)) {
        size_t len = s.length();
        while (len > 0 && isspace(char8_t(s[len - 1]))) --len;
        s.resize(len);

        string cmd, user, book;
        {
            istringstream iss(s);
            iss >> cmd;
            iss >> user;
            char c;
            if (iss.get(c)) {
                while (1) {
                    if (!isspace(char8_t(c))) {
                        iss.putback(c);
                        break;
                    }
                    if (!iss.get(c)) {
                        break;
                    }
                }
            }
            getline(iss, book);
        }

        if (!user.length() || !book.length())
            abort();

        if (cmd == "B") {
        } else if (cmd == "R") {
        } else {
            abort();
        }

        if (auto it = users.find(user); it == users.end()) {
            users.emplace(user, UserInfo{});
        }
        if (auto it = books.find(book); it == books.end()) {
            books.emplace(book, BookInfo{});
        }

        commands.emplace_back(move(cmd), move(user), move(book));
    }

    size_t maxwaitcnt = 0;
    size_t waitcnt = 0;
    while (1) {
        bool finished = true;
        bool changed = false;
        // loop for all users
        for (auto &p : users) {
            auto &user = p.second;
            if (user.pos >= commands.size()) {
                // finished already
            } else if (!user.pos) {
                user.pos = 1;
                changed = true;
                finished = false;
            } else {
                const auto &c = commands[user.pos];
                if (c.user != p.first) {
                    ++user.pos;
                    changed = true;
                    finished = false;
                } else if (user.is_waiting) {
                    finished = false;
                } else if (c.cmd == "R") {
                    if (user.books.count(c.book) == 0) {
                        abort();
                    }
                    auto it = books.find(c.book);
                    if (it == books.end()) abort();
                    auto &book = it->second;
                    if (book.holder != p.first) abort();
                    book.holder.clear();
                    user.books.erase(c.book);
                    if (book.wq.size() > 0) {
                        auto wake_u = book.wq.front();
                        book.wq.pop_front();
                        auto it2 = users.find(wake_u);
                        if (it2 == users.end()) abort();
                        it2->second.is_waiting = false;
                        --waitcnt;
                    }
                    ++user.pos;
                    changed = true;
                    finished = false;
                } else if (c.cmd == "B") {
                    auto it = books.find(c.book);
                    if (it == books.end()) abort();
                    auto &book = it->second;
                    if (!book.holder.size()) {
                        user.books.insert(c.book);
                        book.holder = c.user;
                        ++user.pos;
                        changed = true;
                        finished = false;
                    } else {
                        book.wq.emplace_back(c.user);
                        ++waitcnt;
                        maxwaitcnt = max(maxwaitcnt, waitcnt);
                        user.is_waiting = true;
                        changed = true;
                        finished = false;
                        if (check(users, books)) {
                            cout << "-" << user.pos << endl;
                            return 0;
                        }
                    }
                } else {
                    abort();
                }
            }
        }
        if (finished) {
            cout << maxwaitcnt << endl;
            break;
        }
        if (!changed) {
            cout << "deadlock!" << endl;
            break;
        }
    }
}
